/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.contact;

import filenet.vw.base.VWDebug;
import filenet.vw.base.VWUDDIRegistry;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.language.VWLanguageElement;
import filenet.vw.toolkit.utils.uicontrols.language.VWLanguageList;
import java.awt.Frame;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.business.Contact;

public class VWContactDescriptionTableModel
extends AbstractTableModel {
    protected static final int COLUMN_ID = 0;
    protected static final int COLUMN_DESCRIPTION = 1;
    protected static final int COLUMN_LANGUAGE = 2;
    protected String[] m_columnNames = new String[]{"", VWResource.s_description, VWResource.s_language};
    protected Frame m_parentFrame = null;
    private Vector m_rowData = null;
    private boolean m_bHasChanged = false;
    private Contact m_contact = null;
    private VWLanguageList m_languageList = new VWLanguageList();
    private Locale m_defaultLocale = Locale.getDefault();
    private JComboBox m_languageTypeComboBox = null;

    public VWContactDescriptionTableModel(Frame parent, Contact theContact) {
        try {
            Vector sourceDescVector;
            this.m_parentFrame = parent;
            this.m_contact = theContact;
            this.m_rowData = new Vector();
            if (this.m_contact != null && (sourceDescVector = this.m_contact.getDescriptionVector()) != null) {
                int sz = sourceDescVector.size();
                for (int i = 0; i < sz; ++i) {
                    Description sourceDesc = (Description)sourceDescVector.elementAt(i);
                    if (sourceDesc == null) continue;
                    this.m_rowData.addElement(new Description(sourceDesc.getValue(), sourceDesc.getLanguageCode()));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void resetData(Vector data) {
        this.m_rowData.clear();
        this.m_rowData = data;
    }

    public Contact[] getDescriptions() {
        Object[] theList = new Contact[this.m_rowData.size()];
        this.m_rowData.copyInto(theList);
        return theList;
    }

    public void setDescriptionVector(Vector data) {
        this.m_rowData = data;
        this.fireTableDataChanged();
        this.m_bHasChanged = true;
    }

    public Description getDescription(int rowIndex) {
        if (rowIndex < 0 || rowIndex > this.m_rowData.size()) {
            return null;
        }
        return (Description)this.m_rowData.elementAt(rowIndex);
    }

    public void setDescription(Description theDescription, int rowIndex) {
        if (rowIndex < 0 || rowIndex > this.m_rowData.size() || theDescription == null) {
            return;
        }
        this.m_rowData.setElementAt(theDescription, rowIndex);
        this.fireTableDataChanged();
        this.m_bHasChanged = true;
    }

    public void addRow() {
        try {
            if (this.m_rowData == null) {
                this.m_rowData = new Vector();
            }
            Description desc = new Description();
            desc.setLanguageCode(this.m_defaultLocale.getLanguage());
            this.m_rowData.addElement(desc);
            int nRow = this.m_rowData.size() - 1;
            this.fireTableRowsInserted(nRow, nRow);
            this.m_bHasChanged = true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public JComboBox getLanguageTypeComboBox() {
        try {
            if (this.m_languageTypeComboBox == null) {
                this.m_languageTypeComboBox = new JComboBox<VWLanguageElement>(this.m_languageList.getLanguageList());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_languageTypeComboBox;
    }

    public boolean hasChanged() {
        return this.m_bHasChanged;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 1: {
                return String.class;
            }
            case 2: {
                return VWLanguageElement.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return this.m_columnNames.length;
    }

    public String getColumnName(int nColumn) {
        if (nColumn < 0 || nColumn > this.m_columnNames.length) {
            return null;
        }
        return this.m_columnNames[nColumn];
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            if (this.m_rowData == null) {
                return null;
            }
            Description oDescription = (Description)this.m_rowData.elementAt(nRowIndex);
            if (oDescription == null) {
                return null;
            }
            switch (nColumnIndex) {
                case 0: {
                    return String.valueOf(nRowIndex + 1);
                }
                case 1: {
                    String desc = oDescription.getValue();
                    if (desc == null) {
                        desc = "";
                    }
                    return desc;
                }
                case 2: {
                    String language = oDescription.getLanguageCode();
                    if (language == null || language.length() <= 0) {
                        oDescription.setLanguageCode(this.m_defaultLocale.getLanguage());
                        language = oDescription.getLanguageCode();
                    }
                    VWLanguageElement le = this.m_languageList.find(language, 1);
                    return le;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRow, int nColumn) {
        return nColumn != 0;
    }

    private int compareStrings(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return 0;
        }
        if (str1 == null && str2 != null) {
            return -1;
        }
        if (str1 != null && str2 == null) {
            return 1;
        }
        return str1.compareTo(str2);
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            if (this.m_rowData == null) {
                return;
            }
            Description oDescription = (Description)this.m_rowData.elementAt(nRowIndex);
            if (oDescription == null) {
                return;
            }
            switch (nColumnIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    oDescription.setValue((String)aValue);
                    this.m_bHasChanged = true;
                    break;
                }
                case 2: {
                    if (aValue != null) {
                        if (aValue instanceof String) {
                            String language = (String)aValue;
                            VWLanguageElement le = this.m_languageList.find(language, 0);
                            if (le != null) {
                                language = le.getCode();
                            }
                            oDescription.setLanguageCode(language);
                        } else if (aValue instanceof VWLanguageElement) {
                            VWLanguageElement le = (VWLanguageElement)aValue;
                            oDescription.setLanguageCode(le.getCode());
                        } else {
                            oDescription.setLanguageCode("");
                        }
                    } else {
                        oDescription.setLanguageCode("");
                    }
                    this.m_bHasChanged = true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean verifyDescriptions() {
        boolean bSuccess = true;
        if (this.m_rowData != null) {
            int sz = this.m_rowData.size();
            block0: for (int i = 0; i < sz; ++i) {
                Description DescriptionItem = (Description)this.m_rowData.elementAt(i);
                String description = DescriptionItem.getValue();
                if (description == null || description.length() < 1) {
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_noContactDescription.toString(String.valueOf(i + 1)), VWResource.s_errorMessage, 1);
                    bSuccess = false;
                    break;
                }
                String language = DescriptionItem.getLanguageCode();
                for (int j = i + 1; j < sz; ++j) {
                    Description targetItem = (Description)this.m_rowData.elementAt(j);
                    if (language.compareTo(targetItem.getLanguageCode()) != 0) continue;
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_duplicateContactDescLanguageTypeInRow.toString(String.valueOf(i + 1), String.valueOf(j + 1)), VWResource.s_errorMessage, 1);
                    bSuccess = false;
                    continue block0;
                }
            }
        }
        return bSuccess;
    }

    public Vector getDescriptionVector() {
        return this.m_rowData;
    }

    public void releaseResources() {
        if (this.m_languageTypeComboBox != null) {
            this.m_languageTypeComboBox.removeAllItems();
            this.m_languageTypeComboBox = null;
        }
    }

    public void up(int rowIndex) {
        try {
            if (rowIndex != 0) {
                Object currentObj = this.m_rowData.elementAt(rowIndex);
                Object previousObj = this.m_rowData.elementAt(rowIndex - 1);
                this.m_rowData.setElementAt(currentObj, rowIndex - 1);
                this.m_rowData.setElementAt(previousObj, rowIndex);
                this.m_bHasChanged = true;
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void down(int rowIndex) {
        try {
            if (rowIndex < this.getRowCount() - 1) {
                Object currentObj = this.m_rowData.elementAt(rowIndex);
                Object previousObj = this.m_rowData.elementAt(rowIndex + 1);
                this.m_rowData.setElementAt(currentObj, rowIndex + 1);
                this.m_rowData.setElementAt(previousObj, rowIndex);
                this.m_bHasChanged = true;
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeRow(int nRow) {
        try {
            if (this.m_rowData == null || nRow < 0 || nRow >= this.m_rowData.size()) {
                return;
            }
            Description rowItem = (Description)this.m_rowData.elementAt(nRow);
            if (rowItem != null) {
                this.m_rowData.removeElementAt(nRow);
                this.fireTableRowsDeleted(nRow, nRow);
                this.m_bHasChanged = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void delete(int rowIndex) {
        try {
            if (rowIndex >= 0 && rowIndex < this.m_rowData.size()) {
                this.m_rowData.removeElementAt(rowIndex);
                this.fireTableRowsDeleted(rowIndex, rowIndex);
                this.m_bHasChanged = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private String checkDuplicateName(String uddiName, int row) {
        String msg = null;
        if (uddiName == null || uddiName.trim().length() < 1) {
            msg = VWResource.s_missingUDDIRegName.toString(String.valueOf(row + 1));
            return msg;
        }
        int rowCount = this.m_rowData.size();
        for (int i = 0; i < rowCount; ++i) {
            if (i == row) continue;
            VWUDDIRegistry uddiReg = (VWUDDIRegistry)this.m_rowData.elementAt(i);
            String urName = uddiReg.getName();
            if (urName == null || urName.length() < 1) {
                msg = VWResource.s_missingUDDIRegName.toString(String.valueOf(i + 1));
                break;
            }
            if (uddiName.compareTo(urName) != 0) continue;
            msg = VWResource.s_duplicatedUDDIRegistryName.toString(uddiName, String.valueOf(i + 1), String.valueOf(row + 1));
            break;
        }
        return msg;
    }
}

